/*
	Save and Restore Preferences - version 2.0
	4 July, 2009
	Copyright 2005-2009 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*global eprint */

/*members itemExists, length, match, push, readFile, replace, 
    toLowerCase, value, writeFile
*/

var prefDef = [];

function getPropertyNames(object) {
    var names = [];
    var elementType;
    for (var element in object) {
        elementType = String(typeof object[element]).toLowerCase();
        if (elementType !== "function") {
        	names.push(element);
        }
    }
    return names;
}

function savePlist(path, widgetName) {
	var data, i;
	
	eprint('Saving preferences to: ' + path);
	
	data  = "";
	data += '<?xml version="1.0" encoding="UTF-8"?>\n';
	data += '<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">\n';
	data += '<plist version="1.0">\n';
	data += '<dict>\n';
		
	for (i = 0; i < prefDef.length; i += 1) {
		data += '\t<key>Pref-' + prefDef[i] + '</key>\n';
		data += '\t<string>' + preferences[prefDef[i]].value + '</string>\n';
	}
	data += '</dict>\n';
	data += '</plist>\n';

	return filesystem.writeFile(path, data);
}

function restorePlist(path, widgetName) {
	var data, i, start, finish, lookFor, pattern, result;

	function escapeString(Str) {
		return Str.replace(/([\W])/g, '\\$1');
	}

	if (!filesystem.itemExists(path)) {
		return false;
	}
	eprint('Restoring preferences from: ' + path);
	
	data = filesystem.readFile(path);
	
	if (data === false) {
		return false;
	}

	//	<key>Pref-cityName</key>
	//	<string>Rishworth, England</string>
	
	for (i = 0; i < prefDef.length; i += 1) {
		start  = escapeString('<key>Pref-' + prefDef[i] + '</key>') + '\\s*?' + escapeString('<string>');
		finish = escapeString('</string>');
		lookFor = start + '([.\\s\\S]*?)' + finish;
		pattern = new RegExp(lookFor);
		result = data.match(pattern);
		if (result !== null) {
			preferences[prefDef[i]].value = result[1];
		} else {
			eprint(prefDef[i] + ': Nothing found');
		}
	}
	return true;
}

prefDef = getPropertyNames(preferences);

